<?php

namespace App\Http\Controllers\user;

use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\BonusLedger;
use App\Models\Checkin;
use App\Models\Commission;
use App\Models\Deposit;
use App\Models\Fund;
use App\Models\Improvment;
use App\Models\Mining;
use App\Models\Notice;
use App\Models\Package;
use App\Models\PaymentMethod;
use App\Models\Purchase;
use App\Models\Task;
use App\Models\User;
use App\Models\UserLedger;
use App\Models\VipSlider;
use App\Models\Withdrawal;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Log;

class UserController extends Controller
{
    public function dashboard()
    {
        return view('app.main.index');
    }


    public function return_pay_number($method){
        $method = DB::table('payment_methods')->where('type', $method)->inRandomOrder()->first();
        return response()->json(['status'=> true, 'data'=> $method]);
    }


    public function vip()
    {
        return view('app.main.vip');
    }

    public function purchase_history()
    {
        return view('app.main.purchase_history');
    }

  

  public function history()
    {
        return view('app.main.history');
    }

    public function history_all()
    {
        return view('app.main.history_all');
    }

    public function ordered()
    {
        return view('app.main.ordered');
    }
   public function myp()
    {
        return view('app.main.myp');
    }

    public function exchange()
    {
        return view('app.main.exchange');
    }


  public function checkin(Request $request)
    {
        // check this user already check it
        $check = Checkin::where('user_id', Auth::user()->id)->orderByDesc('id')->first();
        if ($check){
            //check submit today
            $todayCheck = new Carbon($check->date);
            if ($todayCheck->isToday()){
                return response()->json(['status'=> false, 'message'=> 'Already Check Your Luck Please Come In After 24 Hours']);
            }
        }

        $checkAmount = rand(5,35);

        //Create checkin record
        $model = new Checkin();
        $model->user_id = Auth::id();
        $model->date = Carbon::now();
        $model->amount = $checkAmount;
        $model->save();


        //Added balance in user account
        User::where('id', Auth::user()->id)->update([
//            'balance'=> Auth::user()->balance + setting('checkin_bonus')
            'balance'=> Auth::user()->balance + $checkAmount
        ]);

        return response()->json(['status'=> true,'amount'=> $checkAmount , 'message'=> 'Congratulations get daily checkin bonus']);
    }




    public function vip_commission()
    {
        return view('app.main.vip_commission');
    }

    public function task()
    {
        $user = Auth::user();
        //First Level Users
        $first_level_users = User::where('ref_by', $user->ref_id)->get();
        $first_level_users_ids = [];
        foreach ($first_level_users as $user) {
            array_push($first_level_users_ids, $user->id);
        }

        //Second Level Users
        $second_level_users_ids = [];
        foreach ($first_level_users as $element) {
            $users = User::where('ref_by', $element->ref_id)->get();
            foreach ($users as $user) {
                array_push($second_level_users_ids, $user->id);
            }
        }
        $second_level_users = User::whereIn('id', $second_level_users_ids)->get();

        //Third Level Users
        $third_level_users_ids = [];
        foreach ($second_level_users as $element) {
            $users = User::where('ref_by', $element->ref_id)->get();
            foreach ($users as $user) {
                array_push($third_level_users_ids, $user->id);
            }
        }
        $third_level_users = User::whereIn('id', $third_level_users_ids)->get();
        $team_size = $first_level_users->count() + $second_level_users->count() + $third_level_users->count();

        //Get level wise user ids
        $first_ids = $first_level_users->pluck('id'); //first
        $second_ids = $second_level_users->pluck('id'); //Second
        $third_ids = $third_level_users->pluck('id'); //Third

        $lv1Recharge = Deposit::whereIn('user_id', $first_ids)->where('status', 'approved')->sum('amount');
        $lv2Recharge = Deposit::whereIn('user_id', $second_ids)->where('status', 'approved')->sum('amount');
        $lv3Recharge = Deposit::whereIn('user_id', $third_ids)->where('status', 'approved')->sum('amount');
        $lvTotalDeposit = $lv1Recharge + $lv2Recharge + $lv3Recharge;

        $lv1Withdraw = Withdrawal::whereIn('user_id', $first_ids)->where('status', 'approved')->sum('amount');
        $lv2Withdraw = Withdrawal::whereIn('user_id', $second_ids)->where('status', 'approved')->sum('amount');
        $lv3Withdraw = Withdrawal::whereIn('user_id', $third_ids)->where('status', 'approved')->sum('amount');
        $lvTotalWithdraw = $lv1Withdraw + $lv2Withdraw + $lv3Withdraw;

        $activeMembers1 = Deposit::whereIn('user_id', $first_ids)->where('status', 'approved')->groupBy('user_id')->count();
        $activeMembers2 = Deposit::whereIn('user_id', $second_ids)->where('status', 'approved')->groupBy('user_id')->count();
        $activeMembers3 = Deposit::whereIn('user_id', $third_ids)->where('status', 'approved')->groupBy('user_id')->count();


        $Lv1active = 0;
        $Lv2active = 0;
        $Lv3active = 0;

        foreach ($first_level_users as $uuss) {
            $purchase = Purchase::where('user_id', $uuss->id)->first();
            if ($purchase) {
                $Lv1active = $Lv1active + 1;
            }
        }
        foreach ($second_level_users as $uuss) {
            $purchase = Purchase::where('user_id', $uuss->id)->first();
            if ($purchase) {
                $Lv2active = $Lv2active + 1;
            }
        }
        foreach ($third_level_users as $uuss) {
            $purchase = Purchase::where('user_id', $uuss->id)->first();
            if ($purchase) {
                $Lv3active = $Lv3active + 1;
            }
        }

        $teamTotalActiveMembers = $Lv1active + $Lv2active + $Lv3active;


        return view('app.main.task', compact('team_size', 'teamTotalActiveMembers', 'lv1Recharge', 'lv2Recharge', 'lv3Recharge', 'lv1Withdraw', 'lv2Withdraw', 'lv3Withdraw', 'first_level_users', 'second_level_users', 'third_level_users'));
    }

    public function task_history()
    {
        return view('app.main.task_history');
    }

    public function reword_history()
    {
        return view('app.main.reword_history');
    }

    public function commission()
    {
        return view('app.main.commission');
    }

    public function transfer()
    {
        return view('app.main.transfer');
    }

    public function transfer_request(Request $request)
    {
        $validate = Validator::make($request->all(), [
            'amount'=> 'required'
        ]);
        if ($validate->fails()){
            return redirect()->back()->with('error', 'Amount required.');
        }

        $user = Auth::user();

        if ($user->balance >= $request->amount){

            $user->deposit_balance = $user->deposit_balance + $request->amount;
            $user->balance = $user->balance - $request->amount;
            $user->save();

            return redirect()->back()->with('success', 'Balance transfer successful.');
        }else{
            return redirect()->back()->with('error', 'Withdraw balance low.');
        }
    }

    public function amount_history()
    {
        return view('app.main.amount_history');
    }

    public function package_details($id)
    {
        $package = Package::find($id);
        return view('app.main.package_details', compact('package'));
    }

    public function profile()
    {
        return view('app.main.profile');
    }

    public function team()
    {
        return view('app.main.team.index');
    }


    public function setting()
    {
        return view('app.main.mine.setting');
    }

    public function recharge()
    {
        return view('app.main.deposit.index');
    }

    /*public function recharge_amount($amount, $method)
    {
        $payment_method = PaymentMethod::find($method);
        return view('app.main.deposit.recharge_confirm', compact('payment_method', 'amount'));
    }*/
    
    
    public function recharge_amount($amount, $method)
    {
        
            function orderId()
            {
                $length = 16;
                $characters = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
                $charactersLength = strlen($characters);
                $randomString = "";
                for ($i = 0; $i < $length; $i++) {
                    $randomString .= $characters[rand(0, $charactersLength - 1)];
                }
                date_default_timezone_set("Asia/Kolkata");
                $ddd = date("dmY");
                return $ddd . $randomString;
            }
        
            function generateSign(array $params, $secretkey){
                ksort($params);
                $string = [];
                foreach ($params as $key => $value) {
                    if ($key == 'sign') continue;
                    $string[] = $key . '=' . $value;
                }
                $signStr = implode('&', $string) . '&key=' . base64_decode($secretkey);
                return md5($signStr);
            }
        
            $amo = $amount;
            $order_id = orderId();
            $websiteUrl = "https://royalbusiness.online/";
        
            date_default_timezone_set('Asia/Kolkata');
            $callbackurl = $_SERVER['HTTP_HOST'];
            $pay_notifyurl =  "https://royalbusiness.online/pymentdons";
            $page_url= $websiteUrl . "history";
            $params = [
                'version' => '1.0', 
                'mch_id' => '100666737',
                'mch_order_no' => $order_id,
                'pay_type' => 101,
                'trade_amount' => $amo,
                'order_date' => date("Y-m-d H:i:s"),
                'goods_name' => 'technology',
                'notify_url' => $pay_notifyurl,
                'page_url'=>$page_url
            ];
        
            $params['sign'] = generateSign($params, "OWQ4Zjk4NzlkYzRmNGFiMThkZmM3NDVmNTI0N2FkYjg=");
            $params['sign_type'] = "MD5";
        
            
            $model = new Deposit();
            $model->user_id = Auth::id();
            
            $model->photo = "NA";
            $model->method_name = "Watchpay";
            $model->order_id = $order_id;
            $model->transaction_id = $order_id;
            $model->amount = $amo;
            $model->final_amount = $amo;
            $model->date = date('d-m-Y H:i:s');
            $model->status = 'pending';
            $model->save();
        
            // Send the request to the payment API
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://api.watchglb.com/pay/web',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => http_build_query($params),
                CURLOPT_HTTPHEADER => array(
                    'Cookie: PHPSESSID=lbjsnotksadasv5ng91ts4nlsf'
                ),
            ));
            $response = curl_exec($curl);
            curl_close($curl);
            $json = json_decode($response, 1);
        
            $respCode = $json['respCode'];
        
            if ($respCode == "SUCCESS") {
                $url = $json['payInfo'];
                $_SESSION['orderId'] = $order_id;
                header('Location: ' . $url);
            } else {
                echo "Something went wrong";
                echo "$response";
            }

    }
    
    public function pymentdons(Request $request)
{
    Log::info('Callback received via method: ' . $request->method());

    // Raw body for logging/debugging
    $rawPostData = file_get_contents("php://input");
    Log::info('Raw request body:', ['body' => $rawPostData]);

    $notificationData = [];

    // Check Content-Type to parse properly
    $contentType = $request->header('Content-Type');

    if (stripos($contentType, 'application/json') !== false) {
        $jsonData = json_decode($rawPostData, true);
        if (json_last_error() === JSON_ERROR_NONE) {
            $notificationData = $jsonData;
        }
    } else {
        parse_str($rawPostData, $notificationData);
    }

    // Fallback: merge in query/post params if available
    $notificationData = array_merge($notificationData, $request->all());

    Log::info('Parsed callback data:', $notificationData);

    $mchOrderNo = $notificationData['mchOrderNo'] ?? null;
    if (!$mchOrderNo) {
        Log::error('mchOrderNo missing in callback.', $notificationData);
        return response()->json(['status' => 'error', 'message' => 'mchOrderNo missing'], 400);
    }

    $deposit = Deposit::where('order_id', $mchOrderNo)
              ->where('status', 'pending')
              ->first();

    if ($deposit) {
        $userId = $deposit->user_id;
        $finalAmount = $deposit->final_amount;

        Log::info('Deposit found, updating status to approved.', [
            'user_id' => $userId,
            'amount' => $finalAmount
        ]);

        $deposit->status = 'approved';
        $deposit->transaction_id = $mchOrderNo;
        $deposit->date = date('d-m-Y H:i:s');
        $deposit->feedback = 'Callback';
        $deposit->save();

        $affected = DB::update(
            'UPDATE users SET deposit_balance = deposit_balance + ? WHERE id = ?',
            [$finalAmount, $userId]
        );

        Log::info('User balance updated.', [
            'user_id' => $userId,
            'updated_rows' => $affected
        ]);
    } else {
        Log::warning('No matching deposit found or already processed for mchOrderNo:', ['mchOrderNo' => $mchOrderNo]);
    }
}

    public function deposit_history()
    {

        return view('app.main.deposit_history');
    }
    public function depositSubmit(Request $request)
    {
        $validate = Validator::make($request->all(), [
            'amount' => 'required|numeric',
            'payment_method' => 'required',
            'transaction_id' => 'required',
            'photo' => 'required',
        ]);

        if ($validate->fails()) {
            return back()->withErrors($validate->errors());
        }

        $model = new Deposit();
        $model->user_id = Auth::id();
        $path = uploadImage(false ,$request, 'photo', 'upload/payment/', null, null ,$model->photo);

        $model->photo = $path ?? $model->photo;
        $model->method_name = $request->payment_method;
        $model->order_id = rand(00000,99999);
        $model->transaction_id = $request->transaction_id;
        $model->amount = $request->amount;
        $model->final_amount = $request->amount;
        $model->date = date('d-m-Y H:i:s');
        $model->status = 'pending';
        $model->save();
        return redirect()->route('user.deposit')->with('success', 'Deposit Successfully Sended');
    }

    public function update_profile(Request $request)
    {
        $user = User::find(Auth::id());
        $path = uploadImage(false, $request, 'photo', 'upload/profile/', 200, 200, $user->photo);
        $user->photo = $path ?? $user->photo;

        $user->update();
        return redirect()->route('my.profile')->with('success', 'Successfull');
    }

    public function personal_details()
    {
        return view('app.main.update_personal_details');
    }

    public function card()
    {
        $methods = PaymentMethod::where('status', 'active')->where('id', '!=', 4)->get();

        return view('app.main.gateway_setup', compact('methods'));
    }

    public function setupGateway(Request $request)
    {

    

        User::where('id', Auth::id())->update([
            'name' => $request->name,
            'gateway_method' => $request->gateway_method,
            'gateway_number' => $request->gateway_number,
        ]);
        return redirect()->back()->with('success', 'Successfully Added Bank Account.');
    }

    public function reset_bank()
    {
        User::where('id', Auth::id())->update([
            'gateway_method' => null,
            'gateway_number' => null,
        ]);
        return redirect()->back()->with('success', 'Bank Reset.');
    }

    public function invite()
    {
        return view('app.main.invite');
    }

    public function level()
    {
        return view('app.main.level');
    }

   public function checkinn()
    {
        return view('app.main.checkinn');
    }

    public function service()
    {
        return view('app.main.service');
    }


    public function appreview()
    {
        return view('app.main.appreview');
    }

    public function rule()
    {
        return view('app.main.rule');
    }

    public function partner()
    {
        return view('app.main.partner');
    }

    public function climRecord()
    {
        return view('app.main.climRecord');
    }

    public function add_bank()
    {
        return view('app.main.gateway_setup');
    }

    public function add_bank_create()
    {
        return view('app.main.add_bank_create');
    }

    public function setting_change_password(Request $request)
    {
        //Check current password
        $user = User::find(Auth::id());
        if (Hash::check($request->old_password, $user->password)) {
            if ($request->new_password == $request->confirm_password) {
                $user->password = Hash::make($request->new_password);
                $user->update();
                return redirect()->route('login_password')->with('success', 'Password changed');
            } else {
                return redirect()->route('login_password')->with('success', 'Password not match.');
            }
        } else {
            return redirect()->route('login_password')->with('success', 'Password not match');
        }
    }

    public function confirm_submit(Request $request)
    {
        $data = $request->all();
        $model = new Deposit();
        $model->user_id = $data['ui'];
        $model->method_name = $data['pm'];
        $model->method_number = '01000000000';
        $model->order_id = $data['oid'];
        $model->transaction_id = $data['tid'];
        $model->number = $data['aca'];
        $model->amount = $data['amount'];
        $model->final_amount = $data['amount'];
        $model->usdt = $data['amount'] / setting('rate');
        $model->date = Carbon::now();
        $model->status = 'pending';
        $model->save();
        return response()->json(['status' => true, 'data' => $data]);
    }

    public function download_apk()
    {
        $file = public_path('nordex.apk');
        return response()->file($file, [
            'Content-Type' => 'application/vnd.android.package-archive',
            'Content-Disposition' => 'attachment; filename="nordex.apk"',
        ]);
    }

}







