
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Withdrawal</title>
    <script src="<?php echo e(asset('tree/w/public/js/jquery-1.11.3.min.js')); ?>"></script>
    <link rel="stylesheet" href="<?php echo e(asset('tree/w/public/css/font/font.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('tree/w/public/css/index.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('tree/w/public/css/layui.css')); ?>">
    <style>
        .ww {
            padding: 0 25px;
        }

        .retirar-page {
            font-size: 15px;
            color: #000;
        }

        .title1 {
            margin: 20px 0;
        }

        .input-wrap {
            width: 100%;
            height: auto;
            border-radius: 10px;
            background: rgba(255, 255, 255, 1);
            border: 1px solid rgba(204, 204, 204, 1);
            padding: 4px 12px;
            box-sizing: border-box;
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 7px;
        }

        .input-wrap .sp-row {
            display: flex;
            align-items: center;
            gap: 17px;
            height: 100%;
        }

        .input-wrap .avatar {
            height: 100%;
            border-radius: 50%;
        }

        .input-wrap .arrow {
            width: 30px;
            height: 30px;
            cursor: pointer;
        }

        .input-wrap .input2 {
            flex: 1;
            text-align: right;
            font-size: 15px;
            padding-right: 20px;
            box-sizing: border-box;
        }

        .input-wrap .input2::placeholder {
            color: #000;
            font-size: 15px;
        }

        .form-item {
            display: flex;
            align-items: center;
            font-size: 16px;
            line-height: 15px;
        }

        .form-item input {
            font-size: 16px;
            background-color: transparent;
        }

        .form-item input::placeholder {
            color: #000;
        }

        .input-row {
            display: flex;
            align-items: center;
            gap: 5px;
            margin-top: 14px;
        }

        .input-row input {
            width: 250px;
            height: 40px;
            padding-left: 12px;
            box-sizing: border-box;

            border-radius: 10px;
            background: rgba(255, 255, 255, 1);

            border: 1px solid rgba(112, 112, 112, 1);
        }

        .input-row input::placeholder {
            font-size: 18px;
            color: rgba(174, 174, 174, 1);
        }

        .input-row .t1 {
            width: 85px;
            font-size: 15px;
            text-align: right;
            display: flex;
            align-items: center;
            justify-content: flex-end;
        }

        .input-row .t1 img {
            height: 25px;
        }

        .retirar-page .btn-style {
            width: fit-content;
            padding: 0 5px;
            height: 38px;
            font-size: 15px;
            color: #fff;
            margin: 10px auto 13px;
        }

        .sp-ul {
            margin-left: 16px;
            box-sizing: border-box;
        }

        .sp-ul li {
            font-size: 16px;
            line-height: 15px;
            color: rgba(3, 24, 49, 0.7);
            margin-bottom: 10px;
        }

        .sp-ul li span {
            font-size: 12px;
            color: rgba(255, 0, 0, 0.5);
            margin-right: 2px;
        }

        .note {
            color: rgba(255, 0, 0, 1);
            margin-top: 15px;
        }

        .retirar-tip {
            width: 280px;
            margin-left: 80px;
            margin-top: 14px;
            font-size: 15px;
        }

        .inputlist {
            overflow: hidden;
            height: auto; /* 假设每个form-item高度是42px，这里显示两个 */
            transition: height 0.3s ease-out; /* 添加过渡效果 */
        }

        .form-item {
            display: block;
            transition: opacity 0.3s ease-out; /* 添加过渡效果 */
        }

        .form-item:nth-child(n+3) {
            /*display: none;*/

        }

        .inputlist.open {
            height: auto;
            z-index: 1;
            background: #fff;
            border: 1px solid #f2f2f2;
            padding: 4px;
        }

        .inputlist.open .form-item {
            display: block;
            opacity: 1; /* 展开时，元素变为不透明 */
        }

        .retirar-page .btn-style {
            width: 100%;
            padding: 0 5px;
            height: 38px;
            font-size: 15px;
            color: #fff;
            margin: 10px auto 13px;
            border-radius: 0;
            margin-top: 20px;
        }
    </style>
</head>
<body>
<div class="sp-bg retirar-page">
    <div id="root" class="sp_system" style="zoom: 1.01869;">
        <section>
            <div class="ww retirar-part1">
                <div class="sp-relative"><h5 class="page-title">Withdrawal</h5><img class="icon-back" onclick="goBack()"
                                                                                    src="<?php echo e(asset('tree/w/public/image/back.png')); ?>"
                                                                                    alt=""></div>
                <div class="title1">Your Bank Details :-</div>
                <div class="input-wrap">
                    <div class="sp-row">
                        <div class="inputlist">
                            <br>
                            <div class="form-item"><label for="">IFSC Code: </label><input type="text"
                                                                                          value="<?php echo e(user()->gateway_method); ?>"
                                                                                          name="bank_account"
                                                                                          readonly=""
                                                                                          autocomplete="off"></div>
                            <div class="form-item"><label for="">Ac Number：</label><input type="text"
                                                                                             value="<?php echo e(user()->gateway_number); ?>"
                                                                                             readonly=""></div>
                                                                                             
                <br>
                        </div>
                    </div>
                </div>
                <div class="input-wrap">
                    Withdraw Balance:

                    <input type="text" class="input2" style="text-align: right" value="<?php echo e(price(user()->balance)); ?>"
                           placeholder="88888888888"
                           readonly=""><label for=""> </label></div>
                <form action="<?php echo e(route('user.withdraw.request')); ?>" method="post"><?php echo csrf_field(); ?>
                    <div class="input-row">
                        <div class="t1">Amount <?php echo e(currency()); ?> </div>
                        <input type="number" id="num" name="amount" placeholder="Tax 10%"></div>
                    <div class="input-row">
                        <div class="t1"></div>
                        </div>
<center><div class="input-row">
Withdraw Password<input type="password" placeholder="Enter Withdraw password" maxlength="20" name="password"><img
                                class="eye-icon" src="" alt=""
                                id="togglePassword"></div></center>

                    <div class="sp-btn-success btn-style withdraw">Confirm the withdrawal</div>
                </form>
                <ul class="sp-ul">
                    <li><span>*</span>Minimum withdrawal amount: <?php echo e(price(setting('minimum_withdraw'))); ?></li>
                    <li><span>*</span>Withdrawal time 10.00 AM to 17.00 PM</li>
                    <li><span>*</span>Withdrawal fee: <?php echo e(setting('withdraw_charge')); ?>%</li>
                </ul>
            </div>
        </section>
    </div>
</div>
<script src="<?php echo e(asset('tree/w/public/js/layui.js')); ?>"></script>
<script src="<?php echo e(asset('tree/w/public/js/index.js')); ?>"></script>
<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>

    $(".withdraw").on('click', function () {
        const num = $('#num').val();
        const password = $("input[name=password]").val();

        if (num == ''){
            return message('Enter amount')
        }
        if (password == ''){
            return message('Enter password')
        }

        document.querySelector('form').submit();
    })
</script>
</body>
</html>
<?php /**PATH /home/yachdlcu/royalbusiness.online/resources/views/app/main/withdraw/index.blade.php ENDPATH**/ ?>