<?php
$myPackage = \App\Models\Purchase::where('user_id', user()->id)->where('package_id', $element->id)->where('status', 'active')->first();
?>

<div class="sp-box">
    <div class="title"><?php echo e($element->name); ?></div>
    <div class="wrap">
        <img class="sp-pic" src="<?php echo e(asset($element->photo)); ?>" alt="">
        <div class="sp-content">
            <ul>
                <li>
                    <div class="title-s">Price :</div>
                    <p class="sp-flex-x"><?php echo e(currency()); ?><?php echo e(($element->price)); ?></p>
                </li>
                <div class="row">
                    <li>
                        <div class="title-s">Daily :</div>
                        <p class="sp-flex-x"><?php echo e(currency()); ?><?php echo e(($element->commission_with_avg_amount / $element->validity)); ?></p>
                    </li>
                    <div class="line"></div>
                    <?php if($myPackage): ?>
                        <button type="button" class="btn-style">Activated</button>
                    <?php else: ?>
                        <button type="button" onclick="window.location.href='<?php echo e(route('purchase.confirmation', $element->id)); ?>'" class="btn-style buy">Buy Now</button>
                    <?php endif; ?>
                </div>
                <li>
                    <div class="title-s">Day :</div>
                    <p class="sp-flex-x"><?php echo e($element->validity); ?></p>
                </li>
                <li>
                    <div class="title-s">Total :</div>
                    <p class="sp-flex-x"><?php echo e(currency()); ?><?php echo e(($element->commission_with_avg_amount)); ?></p>
                </li>
            </ul>
            <div class="refresh"><img src="<?php echo e(asset ('tree/dash/public/image/refresh.png')); ?>" alt="">Swap it out</div>
        </div>
    </div>
</div>
<?php /**PATH /home/yachdlcu/royalbusiness.online/resources/views/components/package-box.blade.php ENDPATH**/ ?>